﻿# GTBikeV Configuration options

The GTBikeVConfig.ini file contains the configuration options for the mod. They consist of a key and a value asociated.
The keys are organized in sections.
The currently supported sections and keys for this version are:

## Section [MAIN]

| Key                   |   Description                                           | Default Value |
|-----------------------|-------------------------------------------------------------------------|-----------------------|
| **SelectedBike**          |   Bike used by the avatar during the ride. It can be one of: **Mountain, Tribike, Gravel, Road, Fixie, Commuter or BMX**.<br/> The game does not feature any other bike models.<br/> The type of bike affects the performance depending on the terrain you are riding. ||
| **DebugWindow**           |   Activates the debug view showing internal data in 3 panels, Activity panel, general panel and Simulation data / trainer data panel.| False |
| **LogLevel**              |   Sets the minimum level for the log files. Values from 0 to 5 (Verbose).<br/> If you experience crashes or failures set to 4 or 5 and send the log files with your report.|  3 (Info) |
| **InitialGPSPointLat<br/>InitialGPSPointLong** | Initial GPS coordinates corresponding to the 0,0 coordinates in Los Santos map. The default value maps to a small island in the pacific but you can change it to wherever in the world you want your FIT files to be located at.| |
| **WayPointDefaultColor<br/>WayPointDefaultRadius** | Configures the color and radius of the waypoints shown while following one of the predefined routes. If radius is zero the waypoints are not shown. If there is a specific configuration in the course file, it has precedence over this one.<br/> Maximum radius is 40 and colors are specified in AARRGGBB format.| default color is Yellow green FFADFF2F and default radius 20|
| **FineSteeringValue**     |   Changes the steering sensitivity for the steering keys (A and D).<br/> Valid values are between 0.1 and 1.<br/> A value of 1 will full steer just like the regular steering controls.| 0.7 |
| **ScreenshotIntervalKm**	|   Sets the interval between automatic screenshots, in Kilometers.| 5 Km |
| **ScreenshotXOffset**	    |   Sets the x axis screen offset for the screenshots taken during the activity.<br/>Change this value if you are using multiple screens and your screenshots only show your main display, and you are not running GTA V on that display. In that case set the value to the horizontal resolution of your main screen. If the screen playing the game is to the left of the main screen, you can use negative numbers to find the proper X coordinate.| 0 |
| **MenuAutoOpen**          |   Opens the mod menu anytime the user stops moving, including on start-up. Very useful if only a mouse is available for interaction. <br/>Set to false to activate the menu manually on demand.| True |
| **ChangeCarsForBikes**    |   Sets the percentage of bikes vs cars that will be spawned in the map and the riding style the cyclist will have. The riding styles are **AGRESSIVE**, **BREAKLAWS** and **NORMAL**.<br/>i.e  CHANGECARSFORBIKES = 75,AGRESSIVE<br/>100% will show no cars, 0% will leave the environment unchanged.| 50% and NORMAL riding |
| **DefensiveLevel**        |   Level of self defense when cycling. 0 is passive, no defense. 1 is active, anyone aggressive close by will die. 2 is agressive, anyone not in a bike, too close to us, will die or their vehicle explode. | 1 defensive |
| **BotDefinition**         |   Define the type and number of bots that will ride with you while doing a course<br/> It's a list of comma separated values. Each value is a type of Bot. Bot types are:<br/> 0 : Random<br/> 1 : Companion (Blue blip)<br/>2 : Climber (Orange blip)<br/>3 : Sprinter (Brown blip)<br/>4 : Time Trialer (Purple blip)<br/>i.e. BOTDEFINITION = 1,0,3,4<br/>For no bots use BOTDEFINITION = | Max bots is 5, default is 3, one companion and 2 random (1,0,0) |
| **ShowRTC**               |   Shows a real time clock on screen when the menu is hidden to let you keep track of time and keep your training whithin limits.| FALSE |


## Section [USER]

 |Key                    |   Description|
 |-----------------------|------------------------------------------------------------------------------------------------|
 | **UserWeightKg**      |   User weight for the simulation. In Kilograms. This value changes if you change the weight in the mod menu|
 | **UserFTP**           |   Functional Threshold Power value for the user. |
 | **SelectedPed**       |   Character (also called Ped in GTA V) that will represent the user in the game. Use the mod menu to select one.|

## Section [NETWORK]

| Key                    |   Description |
|-----------------------|------------------------------------------------------------------------------------------------|
| **TelemetryReporting** |   Sends anonymous telemetry reporting data, which is used to help understand how to improve the mod. Default is True.<br/> If you don't want to send data then you can disable telemetry by setting value to False. |
| **CourseLibraryURL**        |   URL for remote course downloading.<br/>Don't set or change unless you know what you are doing.|
| **MultiplayerServerURL**    |   URL for the multiplayer server.<br/>Don't set or change unless you know what you are doing.<br/> Use **NONE** as server URL if you don't want to connect to the multiplayer server.|
| **WorkoutLibraryURL**       |   URL for remote workout downloading.<br/>Don't set or change unless you know what you are doing.|

## Section [DEVICES]

| Key                    |   Description |
|-----------------------|------------------------------------------------------------------------------------------------|
|                      | Sets the mod to listen to a specific ANT device id for every of the ANT+ supported profiles so in case you have more than one device you can select the one you will be using.<br/>The special value 0 means it will pair the first device it finds which is usually fine if you only have one.<br/>The special value 65535 is used when you want to deactivate the reception of a particular device type.|
| **FECDeviceId**            | FEC is an ANT+ smart trainer (Deprecated)|
| **PWRDeviceId**            | PWR is an ANT+ power sensor (Deprecated)|
| **HRDeviceId**             | HR is an ANT+ heart rate strap (Deprecated)|
| **CADDeviceId**            | CAD is an ANT+ cadence sensor (Deprecated)|
| **ControlsDeviceId**       | Controls is an ANT+ remote control  (Deprecated)|
| **FPODDeviceId**           | FPod is a foot pod or stride based running distance device (Deprecated)|
| **SPDDeviceId**            | SPD is a bike speed sensor  (Deprecated)|
| **STEERDeviceId**          | STEER is a steering device (currently only Tacx Blacktrack is supported over ANT)  (Deprecated)|
|||                        
| **BPWRDeviceAddr**         |   BLE Power device address (Deprecated)|
| **BHRDeviceAddr**          |   BLE Heart Rate device address (Deprecated)|
| **BCADDeviceAddr**         |   BLE Cadence sensor address (Deprecated)|
| **BSteerDeviceAddr**       |   BLE Sterzo device address (Deprecated)|
| **BSPDDeviceAddr**         |   BLE Speed sensor address (Deprecated)|
| **BKICKRDeviceAddr**       |   BLE Kickr bike address (for button support only) (Deprecated)|
| **BFTMSDeviceAddr**        |   BLE FTMS device address (Deprecated)|
|                        |   For all the BLE devices, a value of 0 means first device found, like in ANT and to exclude a device type from being detected the special address "FF:FF:FF:FF:FF:FF" is used|
| **Power**					 |   Power source device config | **Auto** |
| **Cadence**				 |   Cadence source device config | **Auto** |
| **Steering**				 |   Steering device config | **Auto** |
| **Controls**				 |   Controls device config | **Auto** |
| **HeartRate**				 |   Heart rate device config | **Auto** |
| **RunningSpeed**			 |   Running Speed device config | **Auto** |
| **RoadFeel**           |   Toggles the road feel simulation for Tacx Neo line of trainers and indoor bikes. <br/>  Possible values are True or False|
| **SteerCalibration**  |   A set of 4 values used to calibrate the steering device. The values are leftmost, center, rightmost and dead angle. <br/> The first 3 values are the numeric measure the steering device gives in those positions, the last value is the % of dead heading value around the center position when GTA does not respond to steering. 1% will allow handlebars wobbling without affecting the steering.<br/> **Default value is -350,0,350,1**|
| **TrainerDifficulty** |   Sets the trainer difficulty level in percentage from 0 to 100. 0 will send 0% of any slope information to the trainer, 100 will send 100% real slopes. Default value is 100 (100%). <br/> This setting affects only the incline value sent to your trainer NOT the one used to calculate virtual speed. Only operates on positive inclines (up hills). If you want to disable the trainer resistance control, but keep receiving the power and cadence, use a value of 255. This can be handy if your trainer or bike has manual control and you want to action it without interference from the mod.|
| **PowerCurve**        |   Defines the power curve of a non smart trainer with a 3rd grade polynomial. This setting is only used when there is no power source and the power has to be calculated from a speed sensor.<br/> The format of this setting is **A,B,C,D,MaxPower**. A,B,C and D are the coefficients of the polynomial:<br/> `Power = A * speed^3 + B * speed ^2 + C * speed + D`<br/> The max power setting is to cap the curve because most 3rd degree polys tend to diverge on the edge cases and the power resulting at speeds faster than the last sampled speed would be impossibly high.<br/>**The default power curve value is: -0.08411716f,1.785549,8.569629,3.836372,250**<br/><br/>In order to shape a curve for your trainer you must sample several power values at different speeds (at least 4, but the more the better) and use a polynomial regression tool (such as excel or online tools) to find the coefficients|
| **VirtualGears**      |   Defines the virtual gear ratios and if virtual gears are enabled or not. First value is True or False, to enable or disable them, followed by as many gear ratios as we want to configure. The default are 24 gear ratios and virtual gears disabled.|
| **BrakingDivisor**    |   Sets a smoothing value for braking. The higher the divisor the smoother, and longer, the braking. Valid values are from 1 to 20. Default is 6.|

## Section [KEYS]

| Key                    |   Description | Default Value |
|-----------------------|------------------------------------------------------------------------------------------------|
|                        |   Defines the keys used for most of the features in the mod. <br/> The Key names must match System.Windows.Forms.Keys enumeration in C# [.NET API](https://docs.microsoft.com/en-us/dotnet/api/system.windows.forms.keys?view=net-5.0)<br/>  or be the key name definitions for the Zwift Play contoller or the Wahoo Kickr bike buttons. </br>Some keys may conflict with the game key settings which has more preference. Be careful not to choose the same key mapping as other mods you may be using at the same time.||
| **MenuKey**                |   Open/Close mod menu key.| **F5**|
| **DebugKey**               |   Open/Close debug windows. |**F11**|
| **ScreenshotKey**          |   Take a screenshot. |**NumPad0**|
| **AutopilotKey**           |   Toggle autopilot. | **NumPad1**|
| **RadioKey**               |   Turn on / change radio station. |**NumPad8**|
| **HUDKey**                 |   Hide / Show the HUD. |**NumPad3**|
| **DestinationKey**         |   Change to random destination while not riding a course. |**NumPad2**|
| **ERGToggleKey**           |   ERG mode toggle key. |**NumPad5, ZP_Right_Shift(L)**|
| **MenuSelectKey**          |   Menu option selection |**ZP_A, WH_Right_Up**|
| **MenuCancelKey**          |   Menu close |**ZP_B, WH_Right_Down**|
| **MenuUpKey**              |   Navigate menu up |**ZP_UpArrow, WH_Left_Up**|
| **MenuDownKey**            |   Navigate menu down |**ZP_DownArrow, WH_Left_Down**|
| **MenuRightKey**           |   Navigate a menu list to the right |**ZP_RightArrow, WH_Left_Shift_Up(L)**|
| **MenuLeftKey**            |   Navigate a menu list to the left |**ZP_LeftArrow, WH_Left_Shift_Down(L)**|
| **DialogOkKey**            |   Select OK button on a dialog screen |**ZP_A, WH_Right_Up**|
| **DialogCancelKey**        |   Select Cancel button on a dialog screen |**ZP_B, WH_Right_Down**|
| **LookBehindKey**          |   Look behind |**ZP_Right_Joy(D),ZP_Right_Joy(U)**|
| **NextCamKey**             |   Next camera view selection|**ZP_Left_Joy_Btn(U)**|
| **GearUpKey**				 |   Engage Next gear in virtual gearing |**NumPad9(U), ZP_Right_Shift(U), ZC_Right_Shift(U)**|
| **GearDownKey**            |   Engage Previous gear in virtual gearing|**NumPad7(U), ZP_Left_Shift(U), ZC_Left_Shift(U)**|
| **MultigeardownKey**       |   Skip down 5 gears in virtual gearing|**ZP_Left_Shift(L), ZC_Left_Shift(L)**|
| **BrakeReleaseKey**        |   They key used to indicate we have ended appying the brakes|**ZP_Right_Brake(U), ZP_Left_Brake(U)**|
| **ExtraBrakeKey**          |   Extra brake key in case the braking device does not work properly||


Key Names for Zwift Controllers and Wahoo bike. Zwift Play begin with ZP, Zwift Ride begin with ZR, Zwift Click begin with ZC and Wahoo Kickr Bike with WH.
The keys names have 3 modifiers, **(U)** for KeyUp event, **(D)** for KeyDown event and **(L)** for long key press event. After a long keypress, there is no key up event.

|Name                    |  Button|
|------------------------|-------------------------------------------------------------------------------------------------
|  ZP_Y<br/>ZR_Y            | 'Y' Key on right pad. 
|  ZP_Z<br/>ZR_Z            | 'Z' Key on right pad. 
|  ZP_A<br/>ZR_A            | 'A' Key on right pad. 
|  ZP_B<br/>ZR_B            | 'B' Key on right pad. 
|  ZP_Right_Shift<br/> ZC_Right_Shift | Shifting long button on right pad
|  ZP_Right_On<br/>ZR_Right_On | On/Off button on right pad
|  ZP_Right_Joy_Btn<br/>ZR_Right_Joy_Btn | Joy pad acting as left/right button on right pad
|  ZP_Right_Brake_Btn    | Joy pad acting as brake button on right pad
|                        |
|  ZP_UpArrow<br/>ZR_UpArrow | Up arrow on left pad
|  ZP_LeftArrow<br/>ZR_LeftArrow | Left arrow on left pad
|  ZP_RightArrow<br/>ZR_RightArrow | Right arrow on left pad
|  ZP_DownArrow<br/>ZP_DownArrow | Down arrow on left pad
|  ZP_Left_Shift<br/>ZC_Left_Shift | Shifgting long button on left pad
|  ZP_Left_On<br/>ZR_Left_On | On/Off button on left pad
|  ZP_Left_Joy_Btn<br/>ZR_Left_Joy_Btn | Joy pad acting as left/right button on left pad
|  ZP_Left_Brake_Btn     | Joy pad acting as brake button on left pad
|                        |
|  ZR_Right_Shift_Up     | Shifting Up button on the Zwift Ride right controller
|  ZR_Right_Shift_Down   | Shifting Down button on the Zwift Ride right controller
|  ZR_Right_PowerUp      | Power up button on the Zwift Ride right controller
|  ZR_Left_Shift_Up      | Shifting Up button on the Zwift Ride left controller
|  ZR_Left_Shift_Down    | Shifting Down button on the Zwift Ride left controller
|  ZR_Left_PowerUp       | Power up button on the Zwift Ride left controller
|                        |
|  WH_Left_Brake         | Left Brake lever (Reserved for braking, not usable)
|  WH_Left_Up            | Left up button
|  WH_Left_Down          | Left down button
|  WH_Left_Shift_Down    | Left shifter down
|  WH_Left_Shift_Up      | Left shifter up
|  WH_Left               | Turn left (Reserved for steering, not usable)
|                        |
|  WH_Right_Brake        | Right brake lever (Reserved for braking, not usable)
|  WH_Right_Down         | Right down button
|  WH_Right_Up           | Right up button
|  WH_Right_Shift_Down   | Right shifter down
|  WH_Right_Shift_Up     | Right shifter up
|  WH_Right              | Turn right (Reserved for steering, not usable)

  Keep in mind that some of the Wahoo buttons are used by the bike itself (i.e. shifting) and assigning those to 
  actions in GTBikeV can lead to unwanted results